#!/bin/bash

DB_DIR=`cd "$(dirname "${BASH_SOURCE[0]}")" && pwd`

. "$DB_DIR/get_SchemaVersion.sh" -
if [ $DBVer == 0 ]; then
    . "$DB_DIR/create_OTaMan.sh"
else
    Product_DBVer=`grep -E '^(\(|[[:space:]]+\().*\);$' "$DB_DIR/sql/tabledata/SchemaVersion.sql" | sed -e 's/^.*(//;s/[ ]//g' | awk -F',' '{print $1"."$2"."$3}'`

    if [ "$Product_DBVer" != "$DBVer" ]; then
        echo "Update OTaMan database schema from version $DBVer to $Product_DBVer"

        . "$DB_DIR/vars.sh"
        TMPDIR=`mktemp -d -t --suffix=_OTaMan`
        BAK_DIR_EXERCISE="$TMPDIR/exercises"
        BAK_FILE_RESULTS="$TMPDIR/results.tsv"
        BAK_FILE_SESSION="$TMPDIR/session.ini"

        [ -z "$sql_cmd" ] && . "$DB_DIR/database_logon.sh"

        echo -n "Backup exercises ... "
        mkdir "$BAK_DIR_EXERCISE"
        "$BINDIR/DBConsoleTool" export_exercise "$BAK_DIR_EXERCISE" localhost OTaMan root "$sql_password"
        if [ $? -eq 0 ]; then
            echo Done
        else
            echo ERROR
            exit 1
        fi

        echo -n "Backup results ... "
        "$BINDIR/DBConsoleTool" export_result "$BAK_FILE_RESULTS" localhost OTaMan root "$sql_password"
        if [ $? -eq 0 ]; then
            echo Done
        else
            echo ERROR
            exit 1
        fi

        echo -n "Backup session ... "
        "$BINDIR/DBConsoleTool" export_session "$BAK_FILE_SESSION" localhost OTaMan root "$sql_password"
        if [ $? -eq 0 ]; then
            echo Done
        else
            echo ERROR
            exit 1
        fi

        echo -n "Install database schema ... "
        bash "$DB_DIR/get_dump_OTaMan.sh" | $sql_cmd
        echo Done

        echo -n "Install templates ... "
        "$BINDIR/DBConsoleTool" import_template "$DB_DIR/templates" localhost OTaMan root "$sql_password"
        if [ $? -eq 0 ]; then
            echo Done
        else
            echo ERROR
        fi

        echo -n "Restore exercises ... "
        "$BINDIR/DBConsoleTool" import_exercise "$BAK_DIR_EXERCISE" localhost OTaMan root "$sql_password"
        if [ $? -eq 0 ]; then
            echo Done
            rm -rf "$BAK_DIR_EXERCISE"
        else
            echo ERROR
        fi

        echo -n "Restore results ... "
        "$BINDIR/DBConsoleTool" import_result "$BAK_FILE_RESULTS" localhost OTaMan root "$sql_password"
        if [ $? -eq 0 ]; then
            echo Done
            rm -rf "$BAK_DIR_RESULT"
        else
            echo ERROR
        fi

        echo -n "Restore session ... "
        "$BINDIR/DBConsoleTool" import_session "$BAK_FILE_SESSION" localhost OTaMan root "$sql_password"
        if [ $? -eq 0 ]; then
            echo Done
            rm -f "$BAK_FILE_SESSION"
        else
            echo ERROR
        fi

        echo -n "Remove temporary directory ... "
        rm -rf "$TMPDIR"
        if [ $? -eq 0 ]; then
            echo Done
        else
            echo ERROR
        fi
    else
        echo "Database schema OTaMan already has a version $Product_DBVer. Update is not needed."
    fi
fi
