@echo off

SetLocal EnableDelayedExpansion

call "%~dp0\vars.cmd"

set "TOOLS_DIR=%REPO_ROOT%\tools"
set "GNUWIN_DIR=%TOOLS_DIR%\gnuwin"

if not exist "%TOOLS_DIR%\" (
	echo The directory "%TOOLS_DIR%" not found
	exit /b 1
)

call "%~dp0\get_SchemaVersion.cmd" -

if /i %DBVer% equ 0 (
	call "%~dp0\create_OTaMan.cmd"
	exit /b
)

echo | set /p="set Product_DBVer=" > "%TEMP%\getProduct_DBVer.cmd"
"%GNUWIN_DIR%\grep" ");" "%~dp0\sql\tabledata\SchemaVersion.sql" | "%GNUWIN_DIR%\sed" -e "s/^.*(//;s/[ ]//g" | "%GNUWIN_DIR%\awk" -F"," "{print $1\"".\""$2\"".\""$3}" >> "%TEMP%\getProduct_DBVer.cmd"
call "%TEMP%\getProduct_DBVer.cmd"
del "%TEMP%\getProduct_DBVer.cmd"

set "RANDOM_SUFFIX=%TIME:~0,2%%TIME:~3,2%%TIME:~6,2%_%RANDOM%"
set "BAK_DIR_EXERCISE=%TEMP%\OTaMan-exercises_%RANDOM_SUFFIX%"
set "BAK_FILE_RESULTS=%TEMP%\OTaMan-results_%RANDOM_SUFFIX%.tsv"
set "BAK_FILE_SESSION=%TEMP%\OTaMan-session_%RANDOM_SUFFIX%.ini"

set /a ExitStatus=0

if not "%Product_DBVer%" == "%DBVer%" (
	echo Update OTaMan database schema from version %DBVer% to %Product_DBVer%
	if not defined sql_args call "%~dp0\database_logon.cmd"

	echo | set /p="Backup exercises ... "
	mkdir "%BAK_DIR_EXERCISE%"
	"%BINDIR%\DBConsoleTool.exe" export_exercise "%BAK_DIR_EXERCISE%" localhost OTaMan root "%sql_password%"
	if /i %ErrorLevel% equ 0 (
		echo Done
	) else (
		echo ERROR
		set /a ExitStatus=1
	)

	echo | set /p="Backup results ... "
	"%BINDIR%\DBConsoleTool.exe" export_result "%BAK_FILE_RESULTS%" localhost OTaMan root "%sql_password%"
	if /i %ErrorLevel% equ 0 (
		echo Done
	) else (
		echo ERROR
		set /a ExitStatus=1
	)

	echo | set /p="Backup session ... "
	"%BINDIR%\DBConsoleTool.exe" export_session "%BAK_FILE_SESSION%" localhost OTaMan root "%sql_password%"
	if /i %ErrorLevel% equ 0 (
		echo Done
	) else (
		echo ERROR
		set /a ExitStatus=1
	)

	echo | set /p="Install database schema ... "
	call "%~dp0\get_dump_OTaMan.cmd" | "%sql_cmd%" %sql_args%
	echo Done

	echo | set /p="Install templates ... "
	"%BINDIR%\DBConsoleTool.exe" import_template "%~dp0\templates" localhost OTaMan root "%sql_password%"
	if /i %ErrorLevel% equ 0 (
		echo Done
	) else (
		echo ERROR
		set /a ExitStatus=1
	)

	echo | set /p="Restore exercises ... "
	"%BINDIR%\DBConsoleTool.exe" import_exercise "%BAK_DIR_EXERCISE%" localhost OTaMan root "%sql_password%"
	if /i %ErrorLevel% equ 0 (
		echo Done
		rd /s /q "%BAK_DIR_EXERCISE%"
	) else (
		echo ERROR
		set /a ExitStatus=1
	)

	echo | set /p="Restore results ... "
	"%BINDIR%\DBConsoleTool.exe" import_result "%BAK_FILE_RESULTS%" localhost OTaMan root "%sql_password%"
	if /i %ErrorLevel% equ 0 (
		echo Done
		del /f /q "%BAK_FILE_RESULTS%"
	) else (
		echo ERROR
		set /a ExitStatus=1
	)

	echo | set /p="Restore session ... "
	"%BINDIR%\DBConsoleTool.exe" import_session "%BAK_FILE_SESSION%" localhost OTaMan root "%sql_password%"
	if /i %ErrorLevel% equ 0 (
		echo Done
		del /f /q "%BAK_FILE_SESSION%"
	) else (
		echo ERROR
		set /a ExitStatus=1
	)
) else (
	echo Database schema OTaMan already has a version %Product_DBVer%. Update is not needed.
)

if /i %ExitStatus% equ 0 (
	timeout 3 2> nul
	if %ErrorLevel% neq 0 ping 127.0.0.1 -n 3 > nul
) else (
	pause
)

EndLocal
