drop view if exists ViewSession;
create view ViewSession
as
select
  idSession,
  idSubUnitType,
  `UnitName`,
  `SubUnitName`,
  `ExerciseCaption`,
  `StartTime`,
  ifnull(`HeaterLevel`, 127) as `HeaterLevel`,
  `DirectionsCount`,
  `StartTargetID`,
  `Rank`.Name as `CommanderRank`,
  `CommanderJobTitle`,
  `CommanderFirstName`,
  `CommanderMiddleName`,
  `CommanderLastName`,
  `HeadShootingName`,
  `OperatorName`,
  `ExpertMode`,
  ifnull(`Completed`, false) as `Completed`
from `Session`
left join `Rank` on `Rank`.idRank = `Session`.idCommanderRank
order by `StartTime`;
