drop view if exists ViewResult;
create view ViewResult
as
select
  Result.idResult as idResult,
  Result.idSession as idSession,
  Rank.`Name` as `RankName`,
  Result.`JobTitle` as `JobTitle`,
  Result.idWeaponType as idWeaponType,
  WeaponType.`Name` as `WeaponTypeName`,
  Result.`WeaponModel` as `WeaponModel`,
  Result.`Seq` as `Seq`,
  Result.`StartTime` as `StartTime`,
  Result.`FirstName` as `FirstName`,
  Result.`MiddleName` as `MiddleName`,
  Result.`LastName` as `LastName`,
  concat_ws(" ", Rank.`Name`, Result.`LastName`, Result.`FirstName`, Result.`MiddleName`) as `ViewName`,
  Result.`HitTagets` as `HitTagets`,
  Result.`Mark` as `Mark`,
  Result.`AmmoCount` as `AmmoCount`,
  Result.`Comment` as `Comment`
from Result
left join Rank on Rank.idRank = Result.idRank
left join WeaponType on WeaponType.idWeaponType = Result.idWeaponType
order by idSession, Seq;
