drop view if exists ViewCommander;
create view ViewCommander
as
select
  Cmd.idCommander as idCommander,
  SubUnit.idUnit as idUnit,
  Staff.idSubUnit as idSubUnit,
  Staff.idStaff as idStaff,
  Soldier.FirstName as FirstName,
  Soldier.MiddleName as MiddleName,
  Soldier.LastName as LastName,
  Soldier.idRank as idRank,
  Rank.Name as RankName,
  Soldier.JobTitle as JobTitle,
  concat_ws(" ", Rank.Name, Soldier.LastName, Soldier.FirstName, Soldier.MiddleName) as ViewName
from Commander as Cmd
left join Staff on Staff.idStaff = Cmd.idStaff
left join Soldier on Soldier.idSoldier = Staff.idSoldier
left join SubUnit on SubUnit.idSubUnit = Staff.idSubUnit
left join Rank on Rank.idRank = Soldier.idRank;
