drop table if exists `Session`;
create table `Session` (
  idSession int unsigned not null auto_increment,
  idSubUnitType int unsigned not null,
  `UnitName` varchar(125) not null,
  `SubUnitName` varchar(125) not null,
  `ExerciseCaption` varchar(255) not null,
  `StartTime` datetime not null,
  `LocalityName` varchar(255) null,
  `HeaterLevel` tinyint unsigned null,
  `DirectionsCount` int not null,
  `StartTargetID` int not null,
  idCommanderRank int unsigned not null,
  `CommanderJobTitle` varchar(100) not null,
  `CommanderFirstName` varchar(75) not null,
  `CommanderMiddleName` varchar(75) not null,
  `CommanderLastName` varchar(75) not null,
  `HeadShootingName` varchar(225) not null,
  `OperatorName` varchar(225) not null,
  `ExpertMode` bool not null,
  `Completed` bool,
  primary key (idSession),
  constraint fkSession_SubUnitType foreign key (idSubUnitType) references `SubUnitType`(idSubUnitType) on delete restrict,
  constraint fkSession_Rank foreign key (idCommanderRank) references `Rank`(idRank) on delete restrict
) engine=InnoDB character set=UTF8;
