drop table if exists `Result`;
create table `Result` (
  idResult int unsigned not null auto_increment,
  idSession int unsigned not null,
  idRank int unsigned not null,
  `JobTitle` varchar(100) null,
  idWeaponType char not null,
  `WeaponModel` varchar(50) null,
  `Seq` int unsigned not null,
  `StartTime` datetime not null,
  `FirstName` varchar(75) not null,
  `MiddleName` varchar(75) not null,
  `LastName` varchar(75) not null,
  `HitTagets` varchar(255) null,
  `Mark` tinyint not null,
  `AmmoCount` int not null,
  `Comment` varchar(255) null,
  primary key (idResult),
  index (idSession),
  constraint fkResult_Session foreign key (idSession) references `Session`(idSession) on delete restrict,
  constraint fkResult_Rank foreign key (idRank) references `Rank`(idRank) on delete restrict,
  constraint fkResult_WeaponType foreign key (idWeaponType) references `WeaponType`(idWeaponType) on delete restrict
) engine=InnoDB character set=UTF8;
