#!/bin/bash

# search mariadb/mysql
sql_cmd=$(command -v mariadb 2>/dev/null)
if [ -z "$sql_cmd" ]; then
    sql_cmd=$(command -v mysql 2>/dev/null)
fi
if [ -z "$sql_cmd" ]; then
    echo "Could not find mariadb or mysql"
    exit 1
fi

# try connect to mariadb without password
if [ "`$sql_cmd -u root mysql -Bse 'show databases' | grep information_schema`" == "information_schema" ]; then
    sql_password=""
else
    echo 'Login as root (MariaDB)'
    read -s -p "Password: " sql_password
    echo
fi
if [ -z "$sql_password" ]; then
    sql_cmd="$sql_cmd -u root"
else
    sql_cmd="$sql_cmd -u root -p"$sql_password""
fi
