#!/bin/bash

DB_DIR=`cd "$(dirname "${BASH_SOURCE[0]}")" && pwd`
. "$DB_DIR/vars.sh"
Product_DBVer=`grep -E '^(\(|[[:space:]]+\().*\);$' "$DB_DIR/sql/tabledata/SchemaVersion.sql" | sed -e 's/^.*(//;s/[ ]//g' | awk -F',' '{print $1"."$2"."$3}'`

echo "Creating and initialization OTaMan database schema version $Product_DBVer"
[ -z "$sql_cmd" ] && . "$DB_DIR/database_logon.sh"

echo -n "Creating database schema ... "
bash "$DB_DIR/get_dump_OTaMan.sh" | $sql_cmd
echo Done

echo -n "Install templates ... "
"$BINDIR/DBConsoleTool" import_template "$DB_DIR/templates" localhost OTaMan root "$sql_password"
if [ $? -eq 0 ]; then
    echo Done
else
    echo ERROR
fi

echo -n "Install exercises ... "
"$BINDIR/DBConsoleTool" import_exercise "$DB_DIR/exercises" localhost OTaMan root "$sql_password"
if [ $? -eq 0 ]; then
    echo Done
else
    echo ERROR
fi
