@echo off

SETLOCAL

call "%~dp0\vars.cmd"

set "TOOLS_DIR=%REPO_ROOT%\tools"
set "GNUWIN_DIR=%TOOLS_DIR%\gnuwin"

if not exist "%TOOLS_DIR%\" (
	echo The directory "%TOOLS_DIR%" not found
	exit /b 1
)

echo | set /p="set Product_DBVer=" > "%TEMP%\getProduct_DBVer.cmd"
"%GNUWIN_DIR%\grep" ");" "%~dp0\sql\tabledata\SchemaVersion.sql" | "%GNUWIN_DIR%\sed" -e "s/^.*(//;s/[ ]//g" | "%GNUWIN_DIR%\awk" -F"," "{print $1\"".\""$2\"".\""$3}" >> %TEMP%\getProduct_DBVer.cmd
call "%TEMP%\getProduct_DBVer.cmd"
del "%TEMP%\getProduct_DBVer.cmd"

set /a ExitStatus=0

echo Creating and initialization OTaMan database schema version %Product_DBVer%
if not defined sql_args call "%~dp0\database_logon.cmd"

echo | set /p="Creating database schema ... "
call "%~dp0\get_dump_OTaMan.cmd" | "%sql_cmd%" %sql_args%
echo Done

echo | set /p="Install templates ... "
"%BINDIR%\DBConsoleTool.exe" import_template "%~dp0\templates" localhost OTaMan root "%sql_password%"
if /i %ErrorLevel% equ 0 (
	echo Done
) else (
	echo ERROR
	set /a ExitStatus=1
)

echo | set /p="Install exercises ... "
"%BINDIR%\DBConsoleTool.exe" import_exercise "%~dp0\exercises" localhost OTaMan root "%sql_password%"
if /i %ErrorLevel% equ 0 (
	echo Done
) else (
	echo ERROR
	set /a ExitStatus=1
)

if /i %ExitStatus% equ 0 (
	timeout 3 2> nul
	if %ErrorLevel% neq 0 ping 127.0.0.1 -n 3 > nul
) else (
	pause
)

ENDLOCAL
