#!/bin/bash

DB_DIR=`cd "$(dirname "${BASH_SOURCE[0]}")" && pwd`

. "$DB_DIR/vars.sh"
TMPDIR=`mktemp -d -t --suffix=_OTaMan`
echo -n "Backup directory: $TMPDIR"
BAK_DIR_EXERCISE="$TMPDIR/exercises"
BAK_FILE_RESULTS="$TMPDIR/results.tsv"
BAK_FILE_SESSION="$TMPDIR/session.ini"

[ -z "$sql_cmd" ] && . "$DB_DIR/database_logon.sh"

echo -n "Backup exercises ... "
mkdir "$BAK_DIR_EXERCISE"
"$BINDIR/DBConsoleTool" export_exercise "$BAK_DIR_EXERCISE" localhost OTaMan root "$sql_password"
if [ $? -eq 0 ]; then
    echo Done
else
    echo ERROR
    exit 1
fi

echo -n "Backup results ... "
"$BINDIR/DBConsoleTool" export_result "$BAK_FILE_RESULTS" localhost OTaMan root "$sql_password"
if [ $? -eq 0 ]; then
    echo Done
else
    echo ERROR
    exit 1
fi

echo -n "Backup session ... "
"$BINDIR/DBConsoleTool" export_session "$BAK_FILE_SESSION" localhost OTaMan root "$sql_password"
if [ $? -eq 0 ]; then
    echo Done
else
    echo ERROR
    exit 1
fi
